modelTypes.cierva = 
{

	-- header

	name = "Cierva C-30",
	type = "Airplane",
	amphibious = 0,
	manufacturer = "Phoenix",
	revision = 1.0,
	formatVersion = "5.5.e",
	minProgramVersion = "5.0.a",
	description = "Scale glow auto-gyro",
	physics = physics.airplane,

	class = "Others",
	subclass = "Scale",
	style = "Scale",
	power = "Glow",
	level = "Advanced",

	supportsTrainingGear = 0,


	nodeCount = 135,


	-- main attributes

	attributes =
	{
		Physical =
		{
			Setup = 50.0,
			Size = 2.0,
			Weight = 3.4,
			Robustness = 100.0,
			Centre_of_gravity = { x = 0.0, y = 31.585756, z = 0.0 },
			Inertia = { yaw = 1.0, pitch = 1.0, roll = 1.0 },
			Fuselage_drag_area = { frontal = 0.05, lateral = 0.05, vertical = 0.05 },
			Fuel_Time = 0.0,
			Has_Training_Gear = 0,
			Flip_Rudder_And_Ailerons = 0,
			Cockpit = "WW2_Fighter",
		},

		Fine_tuning =
		{
			Thrust = 100.0,
			Lift = 100.0,
			Engine = 100.0,
			Stall = { severity = 100.0, limit = 100.0 },
			Dihedral = 100.0,
			Elevator = 100.0,
			Aileron = 100.0,
			Rudder = 100.0,
			Wash = 100.0,
			Torque = 100.0,
			Ground_Torque_Effect = 100.0,
			Rudder_Roll_Coupling = 0.0,
			Rudder_Elevator_Coupling = 0.0,
		},

		Controls =
		{
			Throttle =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Elevator =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Aileron =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Rudder =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
				Mix =
				{
						Input = "None",
						Amount = 0.0,
				},

			},

			Collective =
			{
				Low_Rate = 50.0,
				Expo = 0.0,
				Expo_Low_Rate = 0.0,
				Advanced_Expo = 0.0,
				Advanced_Expo_Low_Rate = 0.0,
				Servo_Speed = 25.0,
				Servo_Dead_Zone = 0.0,
				Trim = 0.0,
			},

		},

	},

	body =
	{
		material = "Wood",

		geometry = 
		{

			"glass",
			"rotorController",
			"rotorHousing",
			"rearWheelStrut",
			"canopy",
			"interior",
			"engine",
		},

		collision = 
		{

			{ name = "__collision_box_1", material = "Inherit", type = "box", x = 0.0, y = 20.007217, z = -1.147955, width = 13.953182, height = 16.149078, length = 30.729439, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "__collision_box_2", material = "Inherit", type = "box", x = 0.0, y = 21.188654, z = -22.986526, width = 5.729904, height = 13.075936, length = 22.735338, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
			{ name = "__collision_box_3", material = "Inherit", type = "box", x = 0.0, y = 33.216187, z = -2.15392, width = 4.78519, height = 14.497526, length = 11.827681, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
		},

	},

	propulsion = 
	{

		{
			name = "Propeller",
			type = "propeller",
			pivot = { x = 0.0, y = 19.581591, z = 22.908199 },
			angle = -0.0,
			spinDirection = 1,
			pusher = 0,
			folding = 0,
			blurRadius = 12.305472,
			blurTexture = "None",

			attributes =
			{
				Position = { x = 0.0, y = 19.581591, z = 22.908199 },
				Diameter = 0.5,
				Pitch = 0.1,
				Blade_count = 2,
				Idle_RPM = 0,
				Max_RPM = 8000,
				Throttle_Curve = 1.0,
				Down_thrust = 0.0,
				Right_thrust = 0.0,
				Torque = 100.0,
				Response = { load = 1.0, unload = 1.0 },
				Engine = "None",
				Volume_Tuning = 100.0,
				Pitch_Tuning = 100.0,
			},

			spinGeometry = 
			{

				"prop",
			},

			blurGeometry = 
			{

				"propBlades",
			},

			exhaust = 
			{

				{
					name = "Exhaust",
					position = { x = -0.000704, y = 11.035765, z = 15.194767 },
					vector = { x = 0.0, y = -0.463164, z = -0.886272 },

					attributes =
					{
						Engine_Smoke = 1,
						Engine_Smoke_Intensity = 100.0,
						Display_Smoke = 0,
						Display_Smoke_Colour = { r = 255, g = 255, b = 255, a = 255 },
					},

				},

			},

		},

	},

	gear = 
	{

		{
			name = "Main Gear",
			root_pivot = { x = 5.811303, y = 13.218209, z = -0.658852 },
			tip_pivot = { x = 5.811303, y = 13.218209, z = 6.681993 },
			isBreakable = 1,
			mirrored = 1,
			isGuide = 0,
			guideDirection = 0,
			isRetractable = 0,
			changeTime = 1000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"leftWheelStrut",
					},

					collision = 
					{

					},

				},

				{

					geometry = 
					{

						"rightWheelStrut",
					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "Wheel",
					pivot = { x = 15.130942, y = 3.129546, z = 8.935681 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 1.396033,
					radius = 3.03831,

					sides =
					{
						{

							"leftWheel",
						},

						{

							"rightWheel",
						},

					},

				},

			},

		},

		{
			name = "Rear Gear",
			root_pivot = { x = -5.966277, y = 14.924303, z = -32.85326 },
			tip_pivot = { x = 6.121252, y = 14.922199, z = -32.885178 },
			isBreakable = 1,
			mirrored = 0,
			isGuide = 1,
			guideDirection = 0,
			isRetractable = 0,
			changeTime = 1000.0,
			idle = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			mid = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },
			full = { x = 0.0, y = 0.0, z = 0.0, angle = 0.0 },

			attributes =
			{
				Guide_travel = 20.0,
				Robustness = 100.0,
				Stiffness = 100.0,
				Friction = { frontal = 100.0, lateral = 100.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			wheels = 
			{

				{
					name = "Rear Wheel",
					pivot = { x = 0.001662, y = 10.426148, z = -35.873417 },
					axis = { x = 1.0, y = 0.0, z = 0.0 },
					width = 1.0,
					radius = 1.920047,

					sides =
					{
						{

							"rearWheel",
						},

					},

				},

			},

		},

	},

	airfoils = 
	{

		{
			name = "Fin",
			isBreakable = 1,
			isMirrored = 0,

			attributes =
			{
				Position = { x = 0.000849, y = 10.324423, z = -17.676746 },
				Length = 0.4,
				Root_chord = 0.5,
				Tip_chord = 0.5,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 90.0,
				Sweep = 0.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

					},

					collision = 
					{

						{ name = "__collision_box_5", material = "Inherit", type = "box", x = 0.0, y = 21.188654, z = -38.365585, width = 2.32815, height = 13.075936, length = 8.040272, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

			},

			controlSurfaces = {

				{
					name = "Rudder",
					root_pivot = { x = 0.101631, y = 14.670562, z = -34.311474 },
					tip_pivot = { x = 0.151185, y = 27.577467, z = -34.311443 },

					attributes =
					{
						Input = "Rudder",
						Length = 0.275,
						Tip_distance = 0.05,
						Root_chord = 0.175,
						Tip_chord = 0.175,
						Min_travel = 20.0,
						Max_travel = 20.0,
					},

					sides =
					{
						{

							"rudder",
						},

						{

						},

					},

				},

			},

			flaps = {

			},

			airbrakes = {

			},

		},

		{
			name = "Stabiliser",
			isBreakable = 1,
			isMirrored = 1,

			attributes =
			{
				Position = { x = 0.0, y = 21.244228, z = -23.813936 },
				Length = 0.35,
				Root_chord = 0.1,
				Tip_chord = 0.1,
				Airfoil = "Flat Profile",
				Incidence = 0.0,
				Washout = 0.0,
				Dihedral = 0.0,
				Sweep = 0.0,
				Robustness = 100.0,
				Wash = 100.0,
				Trim = { min = 0.0, max = 0.0 },
			},

			sides =
			{
				{

					geometry = 
					{

						"stabiliser",
					},

					collision = 
					{

						{ name = "__collision_box_4", material = "Inherit", type = "box", x = 0.0, y = 22.689972, z = -26.983576, width = 35.775581, height = 3.211245, length = 6.224503, rot_x = 0.0, rot_y = 0.0, rot_z = 0.0, rot_w = 1.0 },
					},

				},

				{

					geometry = 
					{

					},

					collision = 
					{

					},

				},

			},

			controlSurfaces = {

			},

			flaps = {

			},

			airbrakes = {

			},

		},

	},

	autogyros = 
	{

		{
			name = "Main rotor",
				rotor = { enabled = 1, x = 0.0, y = 42.328144, z = 0.0, angle = 0.0, blurRadius = 50.258301 },
			spinDirection = 1,
			blurTexture = "None",

			attributes =
			{
				Rotor =
				{
					Position = { x = 0.0, y = 42.328144, z = 0.0 },
					Diameter = 2.0,
					Chord = 0.12,
					Blade_Count = 3,
					Inertia = 0.14,
					Pitch = -3.0,
					Incidence = 10.0,
					Cyclic = { frontal = 0.75, lateral = 0.75 },
					Damping = 6.5,
					Airfoil = "NACA 0015",
				},

			},

			upper = 
			{

				blades = 
				{

					"blade1",
					"blade2",
					"blade3",
				},

				spinGeometry = 
				{

					"rotorHub",
				},

				blurGeometry = 
				{

				},

			},

		},

	},

}